<?php include '../includes/db.php'; ?>
<?php include '../includes/navbar.php'; ?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Form Kredit Makam Al-Firdaus</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: sans-serif;
      background: #f5f5f5;
      margin: 0;
      padding: 0;
    }
    .wrapper {
      max-width: 600px;
      margin: 24px auto;
      background: #fff;
      padding: 24px;
      border-radius: 10px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #006400;
      margin-bottom: 20px;
    }
    label {
      font-weight: bold;
      margin-bottom: 6px;
      display: block;
    }
    input, select {
      width: 100%;
      padding: 10px;
      margin-bottom: 14px;
      border: 1px solid #ccc;
      border-radius: 6px;
    }
    button {
      width: 100%;
      background: #ff7f00;
      color: #fff;
      padding: 12px;
      border: none;
      font-size: 16px;
      font-weight: bold;
      border-radius: 6px;
      cursor: pointer;
    }
    button:hover {
      background: #e56700;
    }
    .output {
      background: #fff9d6;
      border: 1px solid #eee;
      padding: 14px;
      border-radius: 8px;
      margin-top: 18px;
      font-size: 14px;
      display: none;
    }
  </style>
</head>
<body>

<div class="wrapper">
  <h2>Ajukan Kredit Makam Al-Firdaus</h2>

  <?php
    $harga_gram = 0;
    $get = mysqli_query($conn, "SELECT * FROM harga_emas ORDER BY id DESC LIMIT 1");
    if ($row = mysqli_fetch_assoc($get)) {
      $harga_gram = (int)$row['harga_per_gram'];
    }
  ?>

  <form id="formKredit">
    <input type="hidden" id="harga_gram" value="<?= $harga_gram; ?>">

    <label>Nama Lengkap</label>
    <input type="text" name="nama" required>

    <label>No. HP / WhatsApp</label>
    <input type="text" name="hp" required>

    <label>Alamat Lengkap</label>
    <input type="text" name="alamat" required>

    <label>Jumlah Makam</label>
    <input type="number" name="jumlah" min="1" required>

    <label>Tenor Kredit</label>
    <select name="tenor" required>
      <option value="">-- Pilih Tenor --</option>
      <option value="3 Bulan">3 Bulan</option>
      <option value="6 Bulan">6 Bulan</option>
      <option value="12 Bulan">12 Bulan</option>
    </select>

    <div id="output" class="output"></div>

    <button type="submit">Hitung & Kirim ke WhatsApp</button>
  </form>
</div>

<?php include '../includes/footer.php'; ?>

<script>
document.getElementById('formKredit').addEventListener('submit', function(e) {
  e.preventDefault();

  const hargaPerGram = parseInt(document.getElementById('harga_gram').value);
  const hargaMakam = hargaPerGram * 3;

  const nama = this.nama.value;
  const hp = this.hp.value;
  const alamat = this.alamat.value;
  const jumlah = parseInt(this.jumlah.value);
  const tenor = this.tenor.value;

  const totalHarga = hargaMakam * jumlah;
  const dp = totalHarga * 0.20;
  const bunga = totalHarga * 0.10;
  const totalAngsuran = totalHarga + bunga - dp;

  const lamaCicilan = tenor.includes("12") ? 12 : (tenor.includes("6") ? 6 : 3);
  const cicilan = Math.ceil(totalAngsuran / lamaCicilan);

  const output = `
    <b>Harga per Makam:</b> Rp ${hargaMakam.toLocaleString()}<br>
    <b>Total Harga:</b> Rp ${totalHarga.toLocaleString()}<br>
    Bunga (10%): Rp ${bunga.toLocaleString()}<br>
    DP (20%): Rp ${dp.toLocaleString()}<br>
    <b>Total Angsuran:</b> Rp ${totalAngsuran.toLocaleString()}<br>
    Tenor: ${tenor}<br>
    <b>Cicilan per Bulan:</b> Rp ${cicilan.toLocaleString()}
  `;
  document.getElementById('output').style.display = 'block';
  document.getElementById('output').innerHTML = output;

  const pesan = `Assalamualaikum, saya ingin mengajukan *kredit makam Al-Firdaus*:\n\n` +
    `Nama: ${nama}\nNo HP: ${hp}\nAlamat: ${alamat}\nJumlah Makam: ${jumlah}\n` +
    `Tenor: ${tenor}\nHarga per Makam: Rp ${hargaMakam.toLocaleString()}\n` +
    `Total Harga: Rp ${totalHarga.toLocaleString()}\nBunga 10%: Rp ${bunga.toLocaleString()}\n` +
    `DP 20%: Rp ${dp.toLocaleString()}\nTotal Angsuran: Rp ${totalAngsuran.toLocaleString()}\n` +
    `Cicilan / Bulan: Rp ${cicilan.toLocaleString()}`;

  const url = `https://wa.me/6289652748080?text=${encodeURIComponent(pesan)}`;
  setTimeout(() => { window.open(url, '_blank'); }, 1000);
});
</script>

</body>
</html>
