
<?php
// admin/includes/navbar.php
// Catatan: file ini SENGAJA tidak mendefinisikan fungsi PHP apa pun.

$base = defined('BASE_URL') ? rtrim(BASE_URL, '/') : '';
$u = function(string $p) use ($base) { return $base . '/' . ltrim($p, '/'); };

$who = $_SESSION['user_name'] ?? 'Administrator';

// deteksi aktif menu
$path = $_SERVER['REQUEST_URI'] ?? '';
$active = function(string $needle) use ($path) {
  return (strpos($path, $needle) !== false) ? 'adm-nav__link--active' : '';
};
?>
<style>
/* ===== Admin Navbar (scoped: adm-nav*) ===== */
.adm-layout{display:grid;grid-template-columns:260px 1fr;min-height:100vh;background:#0f172a}
@media(max-width:980px){.adm-layout{grid-template-columns:1fr}}

.adm-nav{background:#0b1220;color:#dbe2f3;position:sticky;top:0;height:100vh}
@media(max-width:980px){.adm-nav{position:fixed;left:0;top:0;bottom:0;transform:translateX(-100%);transition:transform .25s ease;z-index:60;width:260px}}
.adm-nav--open{transform:translateX(0)}

.adm-nav__brand{display:flex;align-items:center;gap:10px;padding:16px;border-bottom:1px solid #1f2a44}
.adm-nav__brand img{height:24px}
.adm-nav__menu{padding:10px}
.adm-nav__section{margin:10px 0 0 0}
.adm-nav__title{font-size:12px;letter-spacing:.08em;color:#8fa3c8;margin:12px 12px 6px}
.adm-nav__link{display:flex;align-items:center;gap:10px;padding:10px 12px;margin:4px 8px;border-radius:10px;text-decoration:none;color:#dbe2f3;border:1px solid transparent}
.adm-nav__link:hover{background:#111a2e;border-color:#1d2b4d}
.adm-nav__link--active{background:#0e2446;border-color:#274777}
.adm-nav__icon{width:18px;height:18px;opacity:.9}

/* Topbar */
.adm-topbar{position:sticky;top:0;z-index:50;background:#0e1624;color:#dbe2f3;border-bottom:1px solid #1f2a44;
  display:flex;align-items:center;justify-content:space-between;padding:10px 16px}
.adm-burger{display:none;background:transparent;border:0;color:#dbe2f3;font-size:22px;line-height:1;cursor:pointer}
@media(max-width:980px){.adm-burger{display:inline-block}}
.adm-topbar__right{display:flex;gap:8px;align-items:center}
.adm-chip{background:#11203a;color:#dbe2f3;border:1px solid #1f2a44;padding:6px 10px;border-radius:999px;font-size:12.5px}
.adm-logout{background:#b91c1c;border:1px solid #b91c1c;color:#fff;padding:8px 12px;border-radius:10px;text-decoration:none;font-weight:700}
.adm-logout:hover{filter:brightness(.95)}

/* Content wrapper */
.adm-content{background:#f6f7fb;min-height:100vh}
</style>

<div class="adm-layout">
  <!-- Sidebar -->
  <nav id="admNav" class="adm-nav">
    <div class="adm-nav__brand">
      <img src="<?= htmlspecialchars($u('assets/img/logo-mini.png')) ?>" onerror="this.src='<?= htmlspecialchars($u('assets/img/logo.png')) ?>'" alt="Cremoid">
      <strong>Cremoid Admin</strong>
    </div>

    <div class="adm-nav__menu">
      <div class="adm-nav__section">
        <div class="adm-nav__title">Main</div>
        <a class="adm-nav__link <?= $active('/admin/index.php') ?>" href="<?= htmlspecialchars($u('admin/index.php')) ?>">
          <svg class="adm-nav__icon" viewBox="0 0 24 24"><path fill="currentColor" d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z"/></svg>
          Dashboard
        </a>
      </div>

      <div class="adm-nav__section">
        <div class="adm-nav__title">Users</div>
        <a class="adm-nav__link <?= $active('/admin/users/') ?>" href="<?= htmlspecialchars($u('admin/users/index.php')) ?>">
          <svg class="adm-nav__icon" viewBox="0 0 24 24"><path fill="currentColor" d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5s-3 1.34-3 3 1.34 3 3 3zm-8 0c1.66 0 3-1.34 3-3S9.66 5 8 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5C15 14.17 10.33 13 8 13zm8 0c-.29 0-.62.02-.97.05C16.98 13.74 19 14.95 19 16.5V19h5v-2.5c0-2.33-4.67-3.5-8-3.5z"/></svg>
          List User
        </a>
      </div>

      <div class="adm-nav__section">
        <div class="adm-nav__title">Listings</div>
        <a class="adm-nav__link <?= $active('/admin/listings/index.php') ?>" href="<?= htmlspecialchars($u('admin/listings/index.php')) ?>">List Kendaraan</a>
        <a class="adm-nav__link <?= $active('/admin/listings/add.php') ?>"   href="<?= htmlspecialchars($u('admin/listings/add.php')) ?>">Tambah Kendaraan</a>
      </div>

      <div class="adm-nav__section">
        <div class="adm-nav__title">Brands</div>
        <a class="adm-nav__link <?= $active('/admin/brands/') ?>" href="<?= htmlspecialchars($u('admin/brands/index.php')) ?>">List Merk</a>
      </div>

      <div class="adm-nav__section">
        <div class="adm-nav__title">Finance</div>
        <a class="adm-nav__link <?= $active('/admin/finance/') ?>" href="<?= htmlspecialchars($u('admin/finance/index.php')) ?>">Inbox Pengajuan</a>
      </div>
      
           
      <div class="adm-nav__section">
        <div class="adm-nav__title">lead</div>
        <a class="adm-nav__link <?= $active('/admin/lead/cash.php') ?>" href="<?= htmlspecialchars($u('admin/lead/cash.php')) ?>">Cash</a>
        <a class="adm-nav__link <?= $active('/admin/lead/add.php') ?>"   href="<?= htmlspecialchars($u('admin/lead/kredit.php')) ?>">Kredit</a>
      </div>

      <div class="adm-nav__section">
        <div class="adm-nav__title">Artikel</div>
        <a class="adm-nav__link <?= $active('/admin/artikel/index.php') ?>" href="<?= htmlspecialchars($u('admin/artikel/index.php')) ?>">List Artikel</a>
        <a class="adm-nav__link <?= $active('/admin/artikel/add.php') ?>"   href="<?= htmlspecialchars($u('admin/artikel/add.php')) ?>">Tambah Artikel</a>
      </div>
   

      <div class="adm-nav__section">
        <div class="adm-nav__title">Lainnya</div>
        <a class="adm-nav__link <?= $active('/admin/settings.php') ?>" href="<?= htmlspecialchars($u('admin/settings.php')) ?>">Settings</a>
        <a class="adm-nav__link" href="<?= htmlspecialchars($u('')) ?>" target="_blank">Ke Website</a>
        <a class="adm-nav__link" href="<?= htmlspecialchars($u('admin/logout.php')) ?>">Logout</a>
      </div>
    </div>
  </nav>

  <!-- Content + Topbar -->
  <div class="adm-content">
    <div class="adm-topbar">
      <button id="admBurger" class="adm-burger" aria-label="Menu">☰</button>
      <div style="font-weight:700">Admin Panel</div>
      <div class="adm-topbar__right">
        <span class="adm-chip">Halo, <?= htmlspecialchars($who) ?></span>
        <a class="adm-logout" href="<?= htmlspecialchars($u('admin/logout.php')) ?>">Logout</a>
      </div>
    </div>

    <!-- Halaman akan me-render konten mulai di bawah ini -->
