<?php
include '../includes/session.php';
include '../includes/functions.php';
include '../includes/db.php';

cek_role(['direktur', 'komisaris']);

$success = '';
$error = '';

// Tambah user
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nama     = mysqli_real_escape_string($conn, $_POST['nama']);
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = md5($_POST['password']); // disarankan ganti bcrypt
    $role     = $_POST['role'];
    $sub_role = $_POST['sub_role'] ?? null;

    $cek = mysqli_query($conn, "SELECT * FROM users WHERE username='$username'");
    if (mysqli_num_rows($cek) > 0) {
        $error = "Username sudah terdaftar.";
    } else {
        $insert = mysqli_query($conn, "
            INSERT INTO users (nama, username, password, role, sub_role)
            VALUES ('$nama', '$username', '$password', '$role', '$sub_role')
        ");
        if ($insert) {
            $success = "User berhasil ditambahkan.";
        } else {
            $error = "Gagal menyimpan ke database.";
        }
    }
}

// Hapus user
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    mysqli_query($conn, "DELETE FROM users WHERE id = '$id'");
    $success = "User berhasil dihapus.";
}

// Ambil semua user
$users = mysqli_query($conn, "SELECT * FROM users ORDER BY role, nama");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Manajemen Pengguna</title>
  <style>
    body { font-family: sans-serif; background: #f4f4f4; padding: 20px; }
    .container { max-width: 900px; margin: auto; background: white; padding: 20px; border-radius: 10px; }
    input, select { width: 100%; padding: 8px; margin-top: 4px; }
    label { margin-top: 12px; display: block; }
    button { margin-top: 16px; padding: 10px 20px; background: #003366; color: white; border: none; }
    .success { color: green; }
    .error { color: red; }
    table { width: 100%; border-collapse: collapse; margin-top: 30px; font-size: 14px; }
    th, td { border: 1px solid #ccc; padding: 8px; }
    th { background: #003366; color: white; }
    a.hapus { color: red; text-decoration: none; }
  </style>
</head>
<body>

<?php include '../includes/navbar.php'; ?>

<div class="container">
  <h2>Manajemen Pengguna</h2>

  <?php if ($success): ?><p class="success"><?= $success ?></p><?php endif; ?>
  <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>

  <form method="POST">
    <label>Nama Lengkap</label>
    <input type="text" name="nama" required>

    <label>Username</label>
    <input type="text" name="username" required>

    <label>Password</label>
    <input type="password" name="password" required>

    <label>Role</label>
    <select name="role" required onchange="document.getElementById('sub-role').style.display = (this.value === 'koordinator') ? 'block' : 'none';">
      <option value="">-- Pilih Role --</option>
      <option value="komisaris">Komisaris</option>
      <option value="direktur">Direktur</option>
      <option value="akuntan">Akuntan</option>
      <option value="hrd">HRD</option>
      <option value="koordinator">Koordinator</option>
    </select>

    <div id="sub-role" style="display: none;">
      <label>Sub-role Koordinator</label>
      <select name="sub_role">
        <option value="">-- Pilih Sub-role --</option>
        <option value="operasional">Operasional</option>
        <option value="keuangan">Keuangan</option>
        <option value="marketing">Marketing</option>
      </select>
    </div>

    <button type="submit">Tambah User</button>
  </form>

  <h3>Daftar Pengguna</h3>
  <table>
    <tr>
      <th>Nama</th>
      <th>Username</th>
      <th>Role</th>
      <th>Sub-role</th>
      <th>Aksi</th>
    </tr>
    <?php while($u = mysqli_fetch_assoc($users)): ?>
    <tr>
      <td><?= $u['nama'] ?></td>
      <td><?= $u['username'] ?></td>
      <td><?= ucfirst($u['role']) ?></td>
      <td><?= $u['sub_role'] ?? '-' ?></td>
      <td><a href="?hapus=<?= $u['id'] ?>" class="hapus" onclick="return confirm('Hapus user ini?')">Hapus</a></td>
    </tr>
    <?php endwhile; ?>
  </table>
</div>

<script>
  // Auto tampilkan sub-role jika reload halaman
  const roleSelect = document.querySelector('select[name="role"]');
  if (roleSelect.value === 'koordinator') {
    document.getElementById('sub-role').style.display = 'block';
  }
</script>

</body>
</html>
